/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class HistoryDataSet
implements LayerManager.LayerChangeListener {
    private static HistoryDataSet historyDataSet;
    private final Map<PrimitiveId, ArrayList<HistoryOsmPrimitive>> data = new HashMap<PrimitiveId, ArrayList<HistoryOsmPrimitive>>();
    private final CopyOnWriteArrayList<HistoryDataSetListener> listeners = new CopyOnWriteArrayList();
    private final Map<Long, Changeset> changesets = new HashMap<Long, Changeset>();

    public static synchronized HistoryDataSet getInstance() {
        if (historyDataSet == null) {
            historyDataSet = new HistoryDataSet();
            MainApplication.getLayerManager().addLayerChangeListener(historyDataSet);
        }
        return historyDataSet;
    }

    public void addHistoryDataSetListener(HistoryDataSetListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeHistoryDataSetListener(HistoryDataSetListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireHistoryUpdated(PrimitiveId id) {
        for (HistoryDataSetListener l : this.listeners) {
            l.historyUpdated(this, id);
        }
    }

    protected void fireCacheCleared() {
        for (HistoryDataSetListener l : this.listeners) {
            l.historyDataSetCleared(this);
        }
    }

    public HistoryOsmPrimitive get(long id, OsmPrimitiveType type, long version) {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        if (version <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "version", version));
        }
        SimplePrimitiveId pid = new SimplePrimitiveId(id, type);
        List versions = this.data.get(pid);
        if (versions == null) {
            return null;
        }
        return versions.stream().filter(primitive -> primitive.matches(id, version)).findFirst().orElse(null);
    }

    public void put(HistoryOsmPrimitive primitive) {
        SimplePrimitiveId id = new SimplePrimitiveId(primitive.getId(), primitive.getType());
        this.data.computeIfAbsent(id, k -> new ArrayList()).add(primitive);
        this.fireHistoryUpdated(id);
    }

    public void putChangeset(Changeset changeset) {
        this.changesets.put(Long.valueOf(changeset.getId()), changeset);
        this.fireHistoryUpdated(null);
    }

    public History getHistory(long id, OsmPrimitiveType type) {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        SimplePrimitiveId pid = new SimplePrimitiveId(id, type);
        return this.getHistory(pid);
    }

    public History getHistory(PrimitiveId pid) {
        SimplePrimitiveId key = new SimplePrimitiveId(pid.getUniqueId(), pid.getType());
        List versions = this.data.get(Objects.requireNonNull(key, "key"));
        if (versions == null) {
            return null;
        }
        for (HistoryOsmPrimitive i : versions) {
            i.setChangeset(this.changesets.get(i.getChangesetId()));
        }
        return new History(pid.getUniqueId(), pid.getType(), versions);
    }

    public void mergeInto(HistoryDataSet other) {
        if (other == null) {
            return;
        }
        this.data.putAll(other.data);
        this.changesets.putAll(other.changesets);
        this.fireHistoryUpdated(null);
    }

    public Collection<Long> getChangesetIds() {
        return this.data.values().stream().flatMap(Collection::stream).map(HistoryOsmPrimitive::getChangesetId).collect(Collectors.toSet());
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        if (MainApplication.getLayerManager().getLayers().isEmpty()) {
            this.clear();
        }
    }

    public void clear() {
        this.data.clear();
        this.fireCacheCleared();
    }
}

